---
generated_at: 2026-02-03 12:00:00
metrics:
  claims_total: 22
  claims_with_evidence: 21
  claims_without_evidence: 1
confidence_derived: 0.95
---

# 根拠レポート：13-Templates Report

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：21 / 22、根拠なし：1
- 優先レビュー（高）
  1. **セキュリティ権限名**：根拠不足

## 2) 参照した情報（Evidence一覧）

- E-01: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` 行65-67（ルート定義）
- E-02: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` 行80-96（doCatRequest処理）
- E-03: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` 行81（matchPattern取得）
- E-04: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` 行82-83（ClusterStateRequest metadata=true）
- E-05: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` 行99-109（テーブルヘッダー定義）
- E-06: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` 行111-140（buildTable処理）
- E-07: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` 行114-124（レガシーテンプレートループ）
- E-08: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` 行126-138（V2テンプレートループ）
- E-09: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` 行115（Regex.simpleMatch）
- E-10: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` 行121（レガシーのcomposed_of空文字）
- E-11: `server/src/main/java/org/opensearch/rest/action/cat/RestTemplatesAction.java` 行133（V2のpriorityOrZero）
- E-12: `docs/code-to-docs/帳票一覧/帳票一覧.csv` 行14（帳票定義）

## 3) Claims と根拠の対応（レビューの主戦場）

| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | エンドポイントは /_cat/templates と /_cat/templates/{name} | E-01 | ○ |
| C-02 | ClusterStateRequest で metadata=true | E-04 | ○ |
| C-03 | nameパラメータ未指定時はnull | E-03 | ○ |
| C-04 | テーブルカラムは name, index_patterns, order, version, composed_of の5つ | E-05 | ○ |
| C-05 | name のaliasは n | E-05 | ○ |
| C-06 | index_patterns のaliasは t | E-05 | ○ |
| C-07 | order のaliasは o, p | E-05 | ○ |
| C-08 | composed_of のaliasは c | E-05 | ○ |
| C-09 | レガシーとV2テンプレートの両方を出力 | E-06 | ○ |
| C-10 | Regex.simpleMatchでパターンフィルタリング | E-09 | ○ |
| C-11 | レガシーテンプレートのcomposed_ofは空文字 | E-10 | ○ |
| C-12 | V2テンプレートはpriorityOrZero()使用 | E-11 | ○ |
| C-13 | index_patterns表示は"[pattern1, pattern2]"形式 | E-07, E-08 | ○ |
| C-14 | アクション名は cat_templates_action | E-01 | ○ |
| C-15 | localパラメータ対応 | E-02 | ○ |
| C-16 | master_timeoutは非推奨 | E-02 | ○ |
| C-17 | ソースファイルは全141行 | E-06 | ○ |
| C-18 | 帳票名は「Templates Report」 | E-12 | ○ |
| C-19 | V2テンプレートのcomposed_ofリストを表示 | E-08 | ○ |
| C-20 | レガシーテンプレートはgetOrder()使用 | E-07 | ○ |
| C-21 | V2テンプレートはversion()使用 | E-08 | ○ |
| C-22 | cluster:monitor/state権限が必要 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- セキュリティ権限名はSecurity pluginに依存
  - 候補：Security plugin documentation / Permission mapping

## 5) リスクフラグ（レビュー観点）
- 0: エンドポイント・カラム定義・レガシー/V2テンプレート処理（ソースコード確認済み）
- 1: セキュリティ権限名（推定値）

## 6) レビュアーチェックリスト（最小）
- [ ] レガシーテンプレートとV2テンプレートの出力カラム差異が正確か確認
- [ ] Regex.simpleMatchの動作仕様が記述と一致するか確認
- [ ] セキュリティ権限名の確認
